/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.gui;

import java.io.IOException;
import java.util.Collection;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import seng201.team43.gui.EndScreenController;
import seng201.team43.gui.GUIManager;
import seng201.team43.gui.GameScreenController;
import seng201.team43.gui.InventoryScreenController;
import seng201.team43.gui.PauseScreenController;
import seng201.team43.gui.SetupScreenController;
import seng201.team43.gui.ShopScreenController;
import seng201.team43.models.GameManager;

public class FXWrapper {
    private Stage stage;
    private GameManager gameManager;
    @FXML
    private Pane pane;

    public void init(Stage stage) {
        this.stage = stage;
        this.gameManager = new GameManager();
        new GUIManager(this::launchSetupScreen, this::launchGameScreen, this::launchInventoryScreen, this::launchShopScreen, this::launchPauseScreen, this::launchEndScreen, this::clearPane);
    }

    public void launchSetupScreen(GUIManager guiManager) {
        try {
            FXMLLoader setupLoader = new FXMLLoader(this.getClass().getResource("/fxml/setup_screen.fxml"));
            setupLoader.setControllerFactory(param -> new SetupScreenController(this.gameManager, guiManager));
            Parent setupParent = (Parent)setupLoader.load();
            this.pane.getChildren().add(setupParent);
            this.stage.setTitle("Tower Dynasty");
            this.stage.setFullScreenExitHint("");
            this.stage.setFullScreen(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void launchGameScreen(GUIManager guiManager) {
        try {
            FXMLLoader gameScreenLoader = new FXMLLoader(this.getClass().getResource("/fxml/game_screen.fxml"));
            gameScreenLoader.setControllerFactory(param -> new GameScreenController(this.gameManager, guiManager));
            Parent setupParent = (Parent)gameScreenLoader.load();
            this.pane.getChildren().add(setupParent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void launchInventoryScreen(GUIManager guiManager) {
        try {
            FXMLLoader inventoryScreenLoader = new FXMLLoader(this.getClass().getResource("/fxml/inventory_screen.fxml"));
            inventoryScreenLoader.setControllerFactory(param -> new InventoryScreenController(this.gameManager, guiManager));
            Parent setupParent = (Parent)inventoryScreenLoader.load();
            this.pane.getChildren().add(setupParent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void launchShopScreen(GUIManager guiManager) {
        try {
            FXMLLoader shopScreenLoader = new FXMLLoader(this.getClass().getResource("/fxml/shop_screen.fxml"));
            shopScreenLoader.setControllerFactory(param -> new ShopScreenController(this.gameManager, guiManager));
            Parent setupParent = (Parent)shopScreenLoader.load();
            this.pane.getChildren().add(setupParent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void launchPauseScreen(GUIManager guiManager) {
        try {
            FXMLLoader pauseScreenLoader = new FXMLLoader(this.getClass().getResource("/fxml/pause_screen.fxml"));
            pauseScreenLoader.setControllerFactory(param -> new PauseScreenController(guiManager));
            Parent setupParent = (Parent)pauseScreenLoader.load();
            this.pane.getChildren().add(setupParent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void launchEndScreen(GUIManager guiManager) {
        try {
            FXMLLoader endScreenLoader = new FXMLLoader(this.getClass().getResource("/fxml/end_screen.fxml"));
            endScreenLoader.setControllerFactory(param -> new EndScreenController(this.gameManager, guiManager));
            Parent setupParent = (Parent)endScreenLoader.load();
            this.pane.getChildren().add(setupParent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clearPane() {
        this.pane.getChildren().removeAll((Collection<?>)this.pane.getChildren());
    }
}

