/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.gui;

import java.util.function.Consumer;
import javafx.application.Platform;

public class GUIManager {
    private final Consumer<GUIManager> setupScreenLauncher;
    private final Consumer<GUIManager> gameScreenLauncher;
    private final Consumer<GUIManager> inventoryScreenLauncher;
    private final Consumer<GUIManager> pauseScreenLauncher;
    private final Consumer<GUIManager> shopScreenLauncher;
    private final Consumer<GUIManager> endScreenLauncher;
    private final Runnable clearScreen;

    public GUIManager(Consumer<GUIManager> setupScreenLauncher, Consumer<GUIManager> gameScreenLauncher, Consumer<GUIManager> inventoryScreenLauncher, Consumer<GUIManager> shopScreenLauncher, Consumer<GUIManager> pauseScreenLauncher, Consumer<GUIManager> endScreenLauncher, Runnable clearScreen) {
        this.setupScreenLauncher = setupScreenLauncher;
        this.gameScreenLauncher = gameScreenLauncher;
        this.inventoryScreenLauncher = inventoryScreenLauncher;
        this.pauseScreenLauncher = pauseScreenLauncher;
        this.shopScreenLauncher = shopScreenLauncher;
        this.endScreenLauncher = endScreenLauncher;
        this.clearScreen = clearScreen;
        this.openSetupScreen();
    }

    public void openSetupScreen() {
        this.setupScreenLauncher.accept(this);
    }

    public void openGameScreen() {
        this.clearScreen.run();
        this.gameScreenLauncher.accept(this);
    }

    public void openInventoryScreen() {
        this.clearScreen.run();
        this.inventoryScreenLauncher.accept(this);
    }

    public void openPauseScreen() {
        this.clearScreen.run();
        this.pauseScreenLauncher.accept(this);
    }

    public void openShopScreen() {
        this.clearScreen.run();
        this.shopScreenLauncher.accept(this);
    }

    public void openEndScreen() {
        this.clearScreen.run();
        this.endScreenLauncher.accept(this);
    }

    public void quitGame() {
        this.clearScreen.run();
        Platform.exit();
    }
}

