/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.gui;

import java.util.List;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import seng201.team43.gui.GUIManager;
import seng201.team43.gui.factories.CartCellFactory;
import seng201.team43.helpers.ButtonHelper;
import seng201.team43.helpers.PopupHelper;
import seng201.team43.helpers.RoundInformation;
import seng201.team43.models.Cart;
import seng201.team43.models.GameManager;
import seng201.team43.models.Tower;
import seng201.team43.models.enums.RoundDifficulty;
import seng201.team43.services.GameService;

public class GameScreenController {
    private final GameService gameService;
    private final GUIManager guiManager;
    @FXML
    private Button inventoryButton;
    @FXML
    private Button pauseButton;
    @FXML
    private Button startButton;
    @FXML
    private Label statsLabel;
    @FXML
    private Pane towerPaneOne;
    @FXML
    private Pane towerPaneTwo;
    @FXML
    private Pane towerPaneThree;
    @FXML
    private Pane towerPaneFour;
    @FXML
    private Pane towerPaneFive;
    @FXML
    private Button easyDifficultyButton;
    @FXML
    private Button mediumDifficultyButton;
    @FXML
    private Button hardDifficultyButton;
    @FXML
    private ListView<Cart> cartsListView;

    public GameScreenController(GameManager gameManager, GUIManager guiManager) {
        this.gameService = new GameService(gameManager);
        this.guiManager = guiManager;
    }

    public void initialize() {
        this.updateVisuals();
        this.cartsListView.setCellFactory(new CartCellFactory());
        this.inventoryButton.setOnAction(event -> this.guiManager.openInventoryScreen());
        this.pauseButton.setOnAction(event -> this.guiManager.openPauseScreen());
        this.startButton.setOnAction(event -> this.startGame());
        List<Button> difficultyButtons = List.of(this.easyDifficultyButton, this.mediumDifficultyButton, this.hardDifficultyButton);
        difficultyButtons.forEach(button -> button.setOnAction(event -> {
            this.setRoundDifficulty((Button)button, difficultyButtons);
            this.updateVisuals();
        }));
    }

    private void updateVisuals() {
        this.displayTowers();
        this.updateStats();
        this.updateRoundDifficultyButtons();
        this.cartsListView.setItems(FXCollections.observableArrayList(this.gameService.getCarts()));
    }

    private void updateStats() {
        String statsText = String.format("Current Round: %s\n", this.gameService.getCurrentRound()) + String.format("Rounds Won: %s\n", this.gameService.getRoundsWon()) + String.format("Rounds Remaining: %s\n", this.gameService.getRemainingRounds()) + String.format("Money: $%.2f\n", this.gameService.getMoney()) + String.format("Level: %s\n", this.gameService.getLevel()) + String.format("Track Distance: %sm", this.gameService.getTrackDistance());
        this.statsLabel.setText(statsText);
        this.statsLabel.setStyle("-fx-text-alignment: center; -fx-font-size: 20;");
    }

    private void setRoundDifficulty(Button button, List<Button> difficultyButtons) {
        RoundDifficulty roundDifficulty = switch (button.getText()) {
            case "Easy" -> RoundDifficulty.EASY;
            case "Medium" -> RoundDifficulty.MEDIUM;
            default -> RoundDifficulty.HARD;
        };
        this.gameService.setRoundDifficulty(roundDifficulty);
        difficultyButtons.forEach(otherButton -> otherButton.setStyle(""));
        ButtonHelper.setBackground(button, roundDifficulty.colour);
    }

    private void updateRoundDifficultyButtons() {
        RoundDifficulty roundDifficulty = this.gameService.getRoundDifficulty();
        Button difficultyButton = switch (roundDifficulty) {
            default -> throw new IncompatibleClassChangeError();
            case RoundDifficulty.EASY -> this.easyDifficultyButton;
            case RoundDifficulty.MEDIUM -> this.mediumDifficultyButton;
            case RoundDifficulty.HARD -> this.hardDifficultyButton;
        };
        ButtonHelper.setBackground(difficultyButton, roundDifficulty.colour);
    }

    private void displayTowers() {
        List<Pane> towerPanes = List.of(this.towerPaneOne, this.towerPaneTwo, this.towerPaneThree, this.towerPaneFour, this.towerPaneFive);
        for (Pane pane : towerPanes) {
            pane.getChildren().clear();
        }
        for (int i = 0; i < this.gameService.getActiveTowers().size(); ++i) {
            Tower tower = this.gameService.getActiveTowers().get(i);
            Pane towerPane = towerPanes.get(i);
            FlowPane towerFlowPane = new FlowPane();
            towerFlowPane.setStyle("-fx-background-color: white; -fx-pref-height: 150; -fx-pref-width: 150; -fx-column-halignment: center; -fx-alignment: center; -fx-orientation: vertical;");
            Label nameLabel = new Label(tower.getName());
            nameLabel.setStyle("-fx-font-size: 15");
            ImageView resourceImage = new ImageView(new Image(Objects.requireNonNull(this.getClass().getResourceAsStream(String.format("/images/towers/%s.png", tower.getResourceType().label.toLowerCase())))));
            resourceImage.setFitWidth(100.0);
            resourceImage.setPreserveRatio(true);
            towerFlowPane.getChildren().addAll((Node[])new Node[]{nameLabel, resourceImage});
            towerPane.getChildren().add(towerFlowPane);
        }
    }

    private void startGame() {
        RoundInformation roundInformation = this.gameService.startRound();
        if (roundInformation.getWon()) {
            if (this.gameService.gameEnded()) {
                this.gameService.setGameWon();
                this.guiManager.openEndScreen();
            } else {
                List<String> randomEventsMessage;
                if (!roundInformation.getLevelledUpTowers().isEmpty()) {
                    for (Tower tower : roundInformation.getLevelledUpTowers()) {
                        PopupHelper.display(this.startButton, String.format("One of your %s towers upgraded and its production increased by 25.", tower.getResourceType().label.toLowerCase()));
                    }
                }
                if (!(randomEventsMessage = this.gameService.runRandomEvents()).isEmpty()) {
                    for (String eventMessage : randomEventsMessage) {
                        PopupHelper.display(this.startButton, eventMessage);
                    }
                }
                PopupHelper.display(this.startButton, String.format("You completed the round!\nMoney Earned: $%s.00", roundInformation.getMoneyEarned()));
                this.gameService.prepareRound();
                this.updateVisuals();
            }
        } else {
            this.guiManager.openEndScreen();
        }
        this.gameService.setPreviousRoundInformation(roundInformation);
        this.displayTowers();
    }
}

