/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.gui;

import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import seng201.team43.exceptions.GameException;
import seng201.team43.gui.GUIManager;
import seng201.team43.gui.factories.TowerCellFactory;
import seng201.team43.gui.factories.UpgradeCellFactory;
import seng201.team43.models.GameManager;
import seng201.team43.models.Purchasable;
import seng201.team43.models.Tower;
import seng201.team43.models.Upgrade;
import seng201.team43.services.InventoryService;

public class InventoryScreenController {
    private final InventoryService inventoryService;
    private final GUIManager guiManager;
    @FXML
    private Button backButton;
    @FXML
    private Button shopButton;
    @FXML
    private ListView<Tower> activeTowersListView;
    @FXML
    private ListView<Tower> reserveTowersListView;
    @FXML
    private ListView<Upgrade> upgradesListView;
    @FXML
    private Button moveTowerButton;
    @FXML
    private Button sellButton;
    @FXML
    private Button assignUpgradeButton;

    public InventoryScreenController(GameManager gameManager, GUIManager guiManager) {
        this.inventoryService = new InventoryService(gameManager);
        this.guiManager = guiManager;
    }

    public void initialize() {
        this.backButton.setOnAction(event -> this.guiManager.openGameScreen());
        this.shopButton.setOnAction(event -> this.guiManager.openShopScreen());
        this.activeTowersListView.setCellFactory(new TowerCellFactory());
        this.reserveTowersListView.setCellFactory(new TowerCellFactory());
        this.upgradesListView.setCellFactory(new UpgradeCellFactory());
        this.updateListViewItems();
        this.setupTowerListViewListener(this.activeTowersListView);
        this.setupTowerListViewListener(this.reserveTowersListView);
        this.upgradesListView.getSelectionModel().getSelectedItems().addListener(u -> {
            this.sellButton.setVisible(true);
            if (this.inventoryService.getSelectedTower() != null) {
                this.assignUpgradeButton.setVisible(true);
            }
            this.inventoryService.setSelectedUpgrade((Upgrade)this.upgradesListView.getSelectionModel().getSelectedItem());
            this.inventoryService.setLastSelectedItem((Purchasable)this.upgradesListView.getSelectionModel().getSelectedItem());
        });
        this.moveTowerButton.setOnAction(event -> {
            try {
                this.inventoryService.moveTower();
                this.updateListViewItems();
                this.activeTowersListView.getSelectionModel().clearSelection();
                this.reserveTowersListView.getSelectionModel().clearSelection();
                this.moveTowerButton.setVisible(false);
            }
            catch (GameException e) {
                e.displayError(this.moveTowerButton);
            }
        });
        this.assignUpgradeButton.setOnAction(event -> {
            try {
                this.inventoryService.applyUpgrade();
            }
            catch (GameException e) {
                e.displayError(this.assignUpgradeButton);
            }
            this.updateListViewItems();
            this.activeTowersListView.getSelectionModel().clearSelection();
            this.reserveTowersListView.getSelectionModel().clearSelection();
            this.upgradesListView.getSelectionModel().clearSelection();
            this.moveTowerButton.setVisible(false);
            this.sellButton.setVisible(false);
            this.assignUpgradeButton.setVisible(false);
        });
        this.sellButton.setOnAction(event -> {
            try {
                this.inventoryService.sellItem();
            }
            catch (GameException e) {
                e.displayError(this.sellButton);
            }
            this.updateListViewItems();
            this.activeTowersListView.getSelectionModel().clearSelection();
            this.reserveTowersListView.getSelectionModel().clearSelection();
            this.upgradesListView.getSelectionModel().clearSelection();
            this.moveTowerButton.setVisible(false);
            this.sellButton.setVisible(false);
            this.assignUpgradeButton.setVisible(false);
        });
    }

    private void updateListViewItems() {
        this.activeTowersListView.setItems(FXCollections.observableArrayList(this.inventoryService.getActiveTowers()));
        this.reserveTowersListView.setItems(FXCollections.observableArrayList(this.inventoryService.getReserveTowers()));
        this.upgradesListView.setItems(FXCollections.observableArrayList(this.inventoryService.getUpgrades()));
    }

    private void setupTowerListViewListener(ListView<Tower> listView) {
        listView.getSelectionModel().getSelectedItems().addListener(t -> {
            this.moveTowerButton.setVisible(true);
            this.sellButton.setVisible(true);
            if (this.inventoryService.getSelectedUpgrade() != null) {
                this.assignUpgradeButton.setVisible(true);
            }
            this.inventoryService.setSelectedTower((Tower)listView.getSelectionModel().getSelectedItem());
            this.inventoryService.setLastSelectedItem((Purchasable)listView.getSelectionModel().getSelectedItem());
        });
    }
}

