/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.gui;

import java.util.List;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import seng201.team43.exceptions.GameException;
import seng201.team43.gui.GUIManager;
import seng201.team43.models.GameManager;
import seng201.team43.models.Purchasable;
import seng201.team43.services.ShopService;

public class ShopScreenController {
    private final ShopService shopService;
    private final GUIManager guiManager;
    @FXML
    private Button backButton;
    @FXML
    private Label moneyLabel;
    @FXML
    private GridPane outerGrid;

    public ShopScreenController(GameManager gameManager, GUIManager guiManager) {
        this.shopService = new ShopService(gameManager);
        this.guiManager = guiManager;
    }

    public void initialize() {
        this.backButton.setOnAction(event -> this.guiManager.openInventoryScreen());
        this.updateMoney();
        List<Purchasable> items = this.shopService.getShopItems();
        int i = 0;
        for (Purchasable item : items) {
            FlowPane itemPane = this.getItemPane(item);
            this.outerGrid.add(itemPane, i, 1);
            Button buyButton = (Button)itemPane.getChildren().get(1);
            if (item.getPurchased().booleanValue()) {
                buyButton.setDisable(true);
            }
            buyButton.setOnAction(event -> {
                try {
                    this.shopService.buyItem(item);
                    buyButton.setDisable(true);
                    this.updateMoney();
                }
                catch (GameException e) {
                    e.displayError(buyButton);
                }
            });
            ++i;
        }
    }

    private FlowPane getItemPane(Purchasable item) {
        FlowPane towerPane = new FlowPane();
        Label descriptionLabel = new Label(item.getDescription());
        Button buyButton = new Button(item.getName());
        Label priceLabel = new Label(String.format("Price: $%s", item.getCost()));
        towerPane.setOrientation(Orientation.VERTICAL);
        towerPane.setAlignment(Pos.CENTER);
        towerPane.setColumnHalignment(HPos.CENTER);
        descriptionLabel.setStyle("-fx-font-size: 20; -fx-text-alignment: center; -fx-text-fill: white;");
        descriptionLabel.setWrapText(true);
        descriptionLabel.setPrefWidth(380.0);
        descriptionLabel.setAlignment(Pos.CENTER);
        buyButton.setStyle("-fx-font-size: 25");
        priceLabel.setStyle("-fx-font-size: 20; -fx-text-fill: white;");
        towerPane.getChildren().addAll((Node[])new Node[]{descriptionLabel, buyButton, priceLabel});
        return towerPane;
    }

    private void updateMoney() {
        this.moneyLabel.setText(String.format("Money: $%.2f", this.shopService.getMoney()));
    }
}

