/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.gui.factories;

import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.text.Font;
import javafx.util.Callback;
import seng201.team43.models.Cart;

public class CartCellFactory
implements Callback<ListView<Cart>, ListCell<Cart>> {
    @Override
    public ListCell<Cart> call(ListView<Cart> cartListView) {
        return new ListCell<Cart>(){

            @Override
            public void updateItem(Cart cart, boolean empty) {
                super.updateItem(cart, empty);
                if (empty || cart == null) {
                    this.setGraphic(null);
                } else {
                    Label label = new Label(String.format("%s Cart\nSize: %s units\nSpeed: %s m/s", cart.getType().label, cart.getSize(), cart.getSpeed()));
                    label.setFont(new Font(20.0));
                    label.setMaxWidth(Double.MAX_VALUE);
                    this.setGraphic(label);
                }
            }
        };
    }
}

