/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.models;

import seng201.team43.models.Tower;
import seng201.team43.models.enums.Resource;
import seng201.team43.models.enums.RoundDifficulty;

public class Cart {
    private final int size;
    private int speed;
    private final int baseSpeed;
    private final Resource type;
    private int currentFilled;

    public Cart(int size, int speed, Resource type) {
        this.size = size;
        this.speed = speed;
        this.baseSpeed = speed;
        this.type = type;
        this.currentFilled = 0;
    }

    public int getSize() {
        return this.size;
    }

    public void setSpeed(RoundDifficulty roundDifficulty) {
        this.speed = switch (roundDifficulty) {
            default -> throw new IncompatibleClassChangeError();
            case RoundDifficulty.EASY -> this.baseSpeed - 1;
            case RoundDifficulty.MEDIUM -> this.baseSpeed;
            case RoundDifficulty.HARD -> this.baseSpeed + 1;
        };
    }

    public int getSpeed() {
        return this.speed;
    }

    public Resource getType() {
        return this.type;
    }

    public int getCurrentFilled() {
        return this.currentFilled;
    }

    public void addCurrentFilled(int amount) {
        this.currentFilled += amount;
    }

    public void setCurrentFilled(int size) {
        this.currentFilled = size;
    }

    public int fill(Tower tower, int trackDistance) {
        if (tower.getResourceType() == this.getType() && !tower.isBroken() && this.getSize() > this.getCurrentFilled()) {
            int cartTimeOnTrack = trackDistance / this.getSpeed();
            int towerFillTimes = Math.floorDiv(cartTimeOnTrack, tower.getReloadSpeed()) + 1;
            int unitsToAdd = towerFillTimes * tower.getProductionUnits();
            if (unitsToAdd >= this.getSize()) {
                unitsToAdd = this.getSize();
            }
            this.addCurrentFilled(unitsToAdd);
            tower.addExperience((int)((double)unitsToAdd * 0.1));
            return towerFillTimes * 10;
        }
        return 0;
    }
}

