/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import seng201.team43.exceptions.GameException;
import seng201.team43.helpers.RoundInformation;
import seng201.team43.models.Cart;
import seng201.team43.models.Inventory;
import seng201.team43.models.ProductionUpgrade;
import seng201.team43.models.Purchasable;
import seng201.team43.models.ReloadUpgrade;
import seng201.team43.models.RepairTowerUpgrade;
import seng201.team43.models.ResourceTypeUpgrade;
import seng201.team43.models.Tower;
import seng201.team43.models.enums.GameDifficulty;
import seng201.team43.models.enums.Resource;
import seng201.team43.models.enums.RoundDifficulty;

public class GameManager {
    private String name;
    private int money = 0;
    private int experience;
    private int moneyGained = 0;
    private int experienceGained;
    private final Inventory inventory = new Inventory();
    private Integer roundCount = 5;
    private Integer currentRound = 0;
    private RoundDifficulty roundDifficulty;
    private final List<Cart> carts = new ArrayList<Cart>();
    private GameDifficulty gameDifficulty;
    private int trackDistance;
    private List<Purchasable> shopItems;
    private boolean gameWon = false;
    private RoundInformation previousRoundInformation;

    public GameManager() {
        this.setGameDifficulty(GameDifficulty.EASY);
        this.setRoundDifficulty(RoundDifficulty.MEDIUM);
    }

    public void setPreviousRoundInformation(RoundInformation roundInformation) {
        this.previousRoundInformation = roundInformation;
    }

    public void setName(String setName) {
        this.name = setName;
    }

    public String getName() {
        return this.name;
    }

    public void setRoundCount(Integer setRounds) throws GameException {
        if (setRounds < 5 || setRounds > 15) {
            throw new GameException("Amount of rounds is not between 5 and 15.");
        }
        this.roundCount = setRounds;
    }

    public Integer getRoundCount() {
        return this.roundCount;
    }

    public GameDifficulty getGameDifficulty() {
        return this.gameDifficulty;
    }

    public void setGameDifficulty(GameDifficulty gameDifficulty) {
        this.gameDifficulty = gameDifficulty;
        this.money = gameDifficulty.startingMoney;
        this.moneyGained = gameDifficulty.startingMoney;
    }

    public void setRoundDifficulty(RoundDifficulty roundDifficulty) {
        this.roundDifficulty = roundDifficulty;
        this.trackDistance = roundDifficulty.trackDistance;
        for (Cart cart : this.getCarts()) {
            cart.setSpeed(roundDifficulty);
        }
    }

    public RoundDifficulty getRoundDifficulty() {
        return this.roundDifficulty;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void addMoney(int money) {
        this.money += money;
        this.moneyGained += money;
    }

    public void removeMoney(int money) throws GameException {
        if (this.getMoney() - money < 0) {
            throw new GameException("You do not have enough money to buy this.");
        }
        this.money -= money;
    }

    public int getMoney() {
        return this.money;
    }

    public void addExperience(int experience) {
        int oldLevel = this.getLevel();
        this.experience += experience;
        this.experienceGained += experience;
        int newLevel = this.getLevel();
        if (newLevel > oldLevel) {
            int levelDifference = newLevel - oldLevel;
            this.addMoney(100 * levelDifference);
        }
    }

    public int getExperienceGained() {
        return this.experienceGained;
    }

    public int getLevel() {
        return Math.floorDiv(this.experience, 10) + 1;
    }

    public Integer getCurrentRound() {
        return this.currentRound;
    }

    public int getTrackDistance() {
        return this.trackDistance;
    }

    public void addCart(Cart cart) {
        this.carts.add(cart);
    }

    public List<Cart> getCarts() {
        return this.carts;
    }

    public void prepareRound() {
        this.currentRound = this.currentRound + 1;
        if (this.getCurrentRound() % 2 != 0) {
            Random random = new Random();
            Resource[] resources = Resource.values();
            int resourceIndex = random.nextInt(resources.length);
            double sizeMultiplier = (double)this.getCurrentRound().intValue() / 10.0 + 1.0;
            int size = (int)(100.0 * sizeMultiplier);
            int speed = 5 + this.getCurrentRound();
            Cart cart = new Cart(size, speed, resources[resourceIndex]);
            cart.setSpeed(this.getRoundDifficulty());
            this.addCart(cart);
        }
        double costMultiplier = this.getGameDifficulty().multiplier;
        ArrayList<RepairTowerUpgrade> items = new ArrayList<RepairTowerUpgrade>(List.of(new ProductionUpgrade((int)(100.0 * costMultiplier), 25), new ReloadUpgrade((int)(100.0 * costMultiplier)), new ResourceTypeUpgrade((int)(75.0 * costMultiplier)), new RepairTowerUpgrade((int)(50.0 * costMultiplier))));
        for (Resource resource : Resource.values()) {
            items.add((RepairTowerUpgrade)((Object)new Tower((int)(100.0 * costMultiplier), resource)));
        }
        Collections.shuffle(items);
        this.shopItems = items.stream().limit(5L).toList();
    }

    public RoundInformation startRound() {
        RoundInformation roundInformation = new RoundInformation();
        for (Tower tower : this.getInventory().getActiveTowers()) {
            for (Cart cart : this.getCarts()) {
                int previousLevel = tower.getLevel();
                int moneyEarned = cart.fill(tower, this.getTrackDistance());
                this.addMoney(moneyEarned);
                roundInformation.addMoneyEarned(moneyEarned);
                if (previousLevel >= tower.getLevel()) continue;
                roundInformation.addLevelledUpTower(tower);
            }
        }
        for (Cart cart : this.getCarts()) {
            if (cart.getCurrentFilled() < cart.getSize()) {
                roundInformation.setWon(false);
                break;
            }
            this.addExperience(2);
            this.addMoney(25);
            roundInformation.addMoneyEarned(25);
        }
        if (roundInformation.getWon()) {
            this.addMoney(50);
            roundInformation.addMoneyEarned(50);
        }
        return roundInformation;
    }

    public List<Purchasable> getShopItems() {
        return this.shopItems;
    }

    public int getMoneyGained() {
        return this.moneyGained;
    }

    public void setGameWon() {
        this.gameWon = true;
    }

    public boolean isGameWon() {
        return this.gameWon;
    }
}

