/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.models;

import java.util.ArrayList;
import java.util.List;
import seng201.team43.exceptions.GameException;
import seng201.team43.models.Purchasable;
import seng201.team43.models.Tower;
import seng201.team43.models.Upgrade;

public class Inventory {
    private ArrayList<Tower> activeTowers = new ArrayList();
    private final ArrayList<Tower> reserveTowers = new ArrayList();
    private final ArrayList<Upgrade> upgrades = new ArrayList();

    public ArrayList<Tower> getActiveTowers() {
        return this.activeTowers;
    }

    public void setActiveTowers(List<Tower> towers) {
        this.activeTowers = new ArrayList<Tower>(towers);
    }

    public void addActiveTower(Tower tower) throws GameException {
        if (this.getActiveTowers().size() >= 5) {
            throw new GameException("You cannot have more than five active towers.");
        }
        this.activeTowers.add(tower);
    }

    public void removeActiveTower(Tower tower) throws GameException {
        if (this.getActiveTowers().size() <= 1) {
            throw new GameException("You cannot have less than one active tower.");
        }
        this.activeTowers.remove(tower);
    }

    public ArrayList<Tower> getReserveTowers() {
        return this.reserveTowers;
    }

    public void addReserveTower(Tower tower) throws GameException {
        if (this.getReserveTowers().size() >= 5) {
            throw new GameException("You cannot have more than five reserve towers.");
        }
        this.reserveTowers.add(tower);
    }

    public void removeReserveTower(Tower tower) {
        this.reserveTowers.remove(tower);
    }

    public ArrayList<Upgrade> getUpgrades() {
        return this.upgrades;
    }

    public void addUpgrade(Upgrade upgrade) {
        this.upgrades.add(upgrade);
    }

    public void removeUpgrade(Upgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    public void addItem(Purchasable item) throws GameException {
        if (item.getClass() == Tower.class) {
            try {
                this.addActiveTower((Tower)item);
            }
            catch (GameException e) {
                try {
                    this.addReserveTower((Tower)item);
                }
                catch (GameException error) {
                    throw new GameException("Both your tower inventories are full and you cannot add any more.");
                }
            }
        } else {
            this.addUpgrade((Upgrade)item);
        }
    }

    public void moveTower(Tower tower) throws GameException {
        if (this.getActiveTowers().contains(tower)) {
            this.addReserveTower(tower);
            this.removeActiveTower(tower);
        } else {
            this.addActiveTower(tower);
            this.removeReserveTower(tower);
        }
    }
}

