/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.models;

import seng201.team43.exceptions.GameException;
import seng201.team43.models.Purchasable;
import seng201.team43.models.Upgrade;
import seng201.team43.models.enums.Resource;

public class Tower
implements Purchasable {
    private Resource resourceType;
    private String name;
    private int reloadSpeed;
    private int productionUnits;
    private int experience;
    private int cost;
    private boolean purchased;
    private boolean broken;

    public Tower(Resource resourceType) {
        this(100, resourceType);
    }

    public Tower(int cost, Resource resourceType) {
        this.resourceType = resourceType;
        this.name = String.format("%s Tower", resourceType.label);
        this.reloadSpeed = 5;
        this.productionUnits = 50;
        this.experience = 0;
        this.cost = cost;
        this.purchased = false;
    }

    public Resource getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Resource resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getReloadSpeed() {
        return this.reloadSpeed;
    }

    public int getProductionUnits() {
        return this.productionUnits;
    }

    public int getLevel() {
        return Math.floorDiv(this.experience, 10) + 1;
    }

    public void addExperience(int experience) {
        int oldLevel = this.getLevel();
        this.experience += experience;
        int newLevel = this.getLevel();
        if (newLevel > oldLevel) {
            int levelDifference = newLevel - oldLevel;
            this.productionUnits += 25 * levelDifference;
        }
    }

    public void levelDown() {
        if (this.getLevel() > 1) {
            this.experience -= 10;
            this.productionUnits -= 25;
        }
    }

    public void applyUpgrade(Upgrade upgrade) throws GameException {
        upgrade.apply(this);
        this.cost += upgrade.getCost();
    }

    public void increaseProductionUnits(Integer productionUnits) {
        this.productionUnits += productionUnits.intValue();
    }

    public void decreaseReloadSpeed(Integer reloadSpeed) throws GameException {
        if (this.reloadSpeed > 1) {
            this.reloadSpeed -= reloadSpeed.intValue();
        } else {
            throw new GameException("Cannot decrease reload speed below 1s.");
        }
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public boolean isBroken() {
        return this.broken;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public int getSellPrice() {
        return (int)Math.round((double)this.getCost() * 0.8);
    }

    @Override
    public String getDescription() {
        return String.format("A tower that generates %s.", this.resourceType.label);
    }

    @Override
    public Boolean getPurchased() {
        return this.purchased;
    }

    @Override
    public void setPurchased() {
        this.purchased = true;
    }
}

