/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import seng201.team43.helpers.RoundInformation;
import seng201.team43.models.Cart;
import seng201.team43.models.GameManager;
import seng201.team43.models.Tower;
import seng201.team43.models.enums.RoundDifficulty;

public class GameService {
    private final GameManager gameManager;
    private final Random random;

    public GameService(GameManager gameManager) {
        this.gameManager = gameManager;
        this.random = new Random();
    }

    public GameService(GameManager gameManager, Random random) {
        this.gameManager = gameManager;
        this.random = random;
    }

    public void setPreviousRoundInformation(RoundInformation roundInformation) {
        this.gameManager.setPreviousRoundInformation(roundInformation);
    }

    public RoundInformation startRound() {
        return this.gameManager.startRound();
    }

    public void prepareRound() {
        List<Cart> carts = this.gameManager.getCarts();
        for (Cart cart : carts) {
            cart.setCurrentFilled(0);
        }
        this.gameManager.prepareRound();
    }

    public List<String> runRandomEvents() {
        List<Tower> activeTowers = this.gameManager.getInventory().getActiveTowers().stream().filter(Predicate.not(Tower::isBroken)).toList();
        List<Tower> reserveTowers = this.gameManager.getInventory().getReserveTowers().stream().filter(Predicate.not(Tower::isBroken)).toList();
        ArrayList<String> activeTowersMessages = this.runTowersRandomEvent(activeTowers, this.gameManager.getInventory().getActiveTowers(), 5);
        ArrayList<String> reserveTowersMessages = this.runTowersRandomEvent(reserveTowers, this.gameManager.getInventory().getReserveTowers(), 6);
        return Stream.concat(activeTowersMessages.stream(), reserveTowersMessages.stream()).toList();
    }

    private ArrayList<String> runTowersRandomEvent(List<Tower> towersToCheck, ArrayList<Tower> towers, int probability) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Tower tower : towersToCheck) {
            int chance = this.random.nextInt(0, probability);
            if (chance != 0) continue;
            int choice = this.random.nextInt(0, 4);
            String resourceLabel = tower.getResourceType().label.toLowerCase();
            switch (choice) {
                case 0: {
                    messages.add(String.format("A %s tower was broken.", resourceLabel));
                    tower.setBroken(true);
                    break;
                }
                case 1: {
                    messages.add(String.format("A %s tower was destroyed and removed from your inventory.", resourceLabel));
                    towers.remove(tower);
                    break;
                }
                case 2: {
                    if (tower.getLevel() <= 1) break;
                    tower.levelDown();
                    messages.add(String.format("A %s tower has had its level decreased.", resourceLabel));
                    break;
                }
                case 3: {
                    messages.add(String.format("A %s tower has had its level increased.", resourceLabel));
                    tower.addExperience(10);
                }
            }
        }
        return messages;
    }

    public void setRoundDifficulty(RoundDifficulty roundDifficulty) {
        this.gameManager.setRoundDifficulty(roundDifficulty);
    }

    public RoundDifficulty getRoundDifficulty() {
        return this.gameManager.getRoundDifficulty();
    }

    public boolean gameEnded() {
        return this.gameManager.getCurrentRound() + 1 > this.gameManager.getRoundCount();
    }

    public List<Cart> getCarts() {
        return this.gameManager.getCarts();
    }

    public void setGameWon() {
        this.gameManager.setGameWon();
    }

    public List<Tower> getActiveTowers() {
        return this.gameManager.getInventory().getActiveTowers().stream().filter(Predicate.not(Tower::isBroken)).toList();
    }

    public int getRemainingRounds() {
        return this.gameManager.getRoundCount() - this.gameManager.getCurrentRound() + 1;
    }

    public int getCurrentRound() {
        return this.gameManager.getCurrentRound();
    }

    public int getRoundsWon() {
        return this.gameManager.getCurrentRound() - 1;
    }

    public double getMoney() {
        return this.gameManager.getMoney();
    }

    public double getTrackDistance() {
        return this.gameManager.getTrackDistance();
    }

    public int getLevel() {
        return this.gameManager.getLevel();
    }
}

