/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.services;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import seng201.team43.exceptions.GameException;
import seng201.team43.models.GameManager;
import seng201.team43.models.Tower;
import seng201.team43.models.enums.GameDifficulty;

public class SetupService {
    private final GameManager gameManager;
    private final Tower[] startingTowers = new Tower[3];

    public SetupService(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    public void setName(String name) {
        this.gameManager.setName(name);
    }

    public void setRoundCount(Integer roundCount) throws GameException {
        this.gameManager.setRoundCount(roundCount);
    }

    public GameDifficulty setGameDifficulty(String difficultyText) {
        GameDifficulty gameDifficulty = switch (difficultyText) {
            case "Medium" -> GameDifficulty.MEDIUM;
            case "Hard" -> GameDifficulty.HARD;
            default -> GameDifficulty.EASY;
        };
        this.gameManager.setGameDifficulty(gameDifficulty);
        return gameDifficulty;
    }

    public void startGame() throws GameException {
        if (this.gameManager.getName() == null) {
            throw new GameException("A name is required.");
        }
        Pattern specialCharacterPattern = Pattern.compile("[^a-zA-Z ]");
        Matcher specialCharacterMatcher = specialCharacterPattern.matcher(this.gameManager.getName());
        if (specialCharacterMatcher.find()) {
            throw new GameException("Your name must not contains special characters.");
        }
        if (this.gameManager.getName().length() > 15 || this.gameManager.getName().length() < 3) {
            throw new GameException("Your name must be between 3-15 characters.");
        }
        this.gameManager.getInventory().setActiveTowers(Arrays.stream(this.startingTowers).filter(Objects::nonNull).toList());
        if (this.gameManager.getInventory().getActiveTowers().isEmpty()) {
            throw new GameException("At least one starting tower is required.");
        }
        this.gameManager.prepareRound();
    }

    public Tower[] getStartingTowers() {
        return this.startingTowers;
    }

    public void setStartingTower(int index, Tower tower) {
        this.startingTowers[index] = tower;
    }
}

