/*
 * Decompiled with CFR 0.152.
 */
package seng201.team43.services;

import java.util.List;
import seng201.team43.exceptions.GameException;
import seng201.team43.models.GameManager;
import seng201.team43.models.Purchasable;

public class ShopService {
    private final GameManager gameManager;

    public ShopService(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    public double getMoney() {
        return this.gameManager.getMoney();
    }

    public List<Purchasable> getShopItems() {
        return this.gameManager.getShopItems();
    }

    public void buyItem(Purchasable item) throws GameException {
        if (item == null) {
            throw new GameException("Invalid item was purchased.");
        }
        if (this.getMoney() - (double)item.getCost() < 0.0) {
            throw new GameException("You do not have enough money to buy this.");
        }
        this.gameManager.getInventory().addItem(item);
        this.gameManager.removeMoney(item.getCost());
        item.setPurchased();
    }
}

